---
type: glossary
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/observation"
---

# Intermittent Awareness (classification)

> Flapping coherence: awareness binds/unbinds under load, jitter, or gating variability.

---

## Definition

- Alternates between coherent and desynchronized states
- Stability depends on environmental conditions
- Pattern of unstable phase transitions

---

## Dual‑register mapping

### Technical (network/computational)

| Diagnostic concept | Network construct | Test example |
|-------------------|------------------|--------------|
| Flapping | State oscillation | `Monitor`, `Flap` |
| Instability | Load sensitivity | `Check`, `Load` |
| Transition | Mode switch | `Detect`, `Switch` |

### Humane (biological/relational)

| Diagnostic concept | Humane construct | Example |
|-------------------|------------------|----------|
| Flapping | On-off pattern | "Comes and goes" |
| Instability | Unreliable | "Sometimes works" |
| Transition | State change | "Switches suddenly" |

### Crosswalk (bridge)

| Technical term | Humane term | Ontological meaning |
|---------------|-------------|-------------------|
| Oscillation | On-off | How stability fails |
| Load sensitivity | Unreliable | What triggers change |
| Mode switch | State change | How pattern shifts |

### Domain Examples

| Domain | Technical test | Humane test |
|--------|---------------|-------------|
| Physics | Mode flapping | Unstable state |
| Networks | Connection flap | Unreliable link |
| Cognition | Attention shift | Wandering mind |
| Systems | State bounce | Pattern flicker |

---

## Scale Effects

How Intermittent Awareness manifests differently at various scales:

### Micro Scale (ε-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ε | Quantum flicker | Wave jump |
| λV | Gate flutter | State flip |

### Human Scale (ψA-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ψA | Phase flap | Attention jump |
| ∇S | Structure flip | Identity shift |

### Cosmic Scale (c-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| c | Causal flicker | Light flap |
| λV | Field oscillation | Structure flip |

Note: At extreme scales, intermittency can become indistinguishable from fundamental limits (e.g., quantum jumps at ε, causal flickers at c).

---

## Invariants / Thresholds

Scale-dependent bounds:
- ε: phase error near threshold
- c: tight capacity margin
- ψA: marginal coherence
- λV: oscillating gates

---

## SVA Coupling

Scale-dependent modulator effects:

| Scale | Modulator | Technical effect | Humane effect |
|-------|-----------|-----------------|---------------|
| Micro | ∇S | Structure flip | Pattern jump |
| Human | λV | Gate oscillation | Boundary flap |
| Cosmic | ψA | Phase flutter | Binding flicker |

---

## Failure Modes

Scale-dependent failure patterns:

| Scale | Mode | Technical signature | Humane signature |
|-------|------|-------------------|------------------|
| Micro | Quantum jump | State flip | Pattern break |
| Human | Load flip | Mode change | Lost stability |
| Cosmic | Field flap | Connection break | Binding jump |

---

## Diagnostic Checklist

Technical tests:
- [ ] State transitions track load/jitter
- [ ] Hysteresis in thresholds
- [ ] Stabilizes with resources
- [ ] Clear transition triggers

Humane tests:
- [ ] Pattern reliability check
- [ ] Stability conditions noted
- [ ] Transition awareness
- [ ] Recovery behavior

---

## Design rationale

This diagnostic must maintain dual-register intelligibility per governance (see [PRINCIPLES.md](../../../../PRINCIPLES.md)). Neither technical oscillation nor experiential unreliability alone captures its full meaning.

---

## See Also

- [[Coherent Awareness (classification)]]
- [[Desynchronized Awareness (classification)]]
- [[Overbound Awareness (classification)]]
- [[Awareness]]
- [[ψA — Awareness Phase Coherence Anchor (Aiza)]]

---

## Dual‑register checklist

- [x] Technical mapping provided
- [x] Humane mapping provided
- [x] Crosswalk table included
- [x] Scale-aware tests documented